# Downloads Domain Package

This folder contains all files that should be hosted on your **separate downloads domain**.

## 📁 Folder Structure

```
downloads-domain/
├── success.html          # Success page shown after verification
├── success.css           # Styles for success page
├── success.js            # JavaScript with security checks
├── upload/              # Upload functionality for admin
│   ├── upload.html      # Upload interface
│   ├── upload.php       # PHP upload handler
│   ├── upload-script.js # Upload JavaScript
│   └── upload-style.css # Upload styles
├── app/                 # APK storage folder
│   └── (place axisinsurance.apk here)
├── img/                 # Required images
│   ├── site-icon.svg
│   ├── googleplay.png
│   └── applestore.png
└── README.md           # This file
```

## 🚀 Setup Instructions

### Step 1: Configure Domain/Subdomain

You can use any of these approaches:

**Option A: Subdomain** (Recommended)
- Create subdomain: `downloads.yoursite.com`
- Point it to this folder

**Option B: Separate Domain**
- Use different domain: `yourdownloads.com`
- Upload all files to that domain

**Option C: Localhost Testing**
- Test on: `http://localhost:8080`
- Run PHP server in this folder

### Step 2: Upload Files

Upload the entire `downloads-domain` folder contents to your server:

**Via FTP/SFTP:**
```bash
# Upload to your server
# Make sure to upload to the web root of your downloads domain
```

**Via cPanel:**
1. Login to cPanel for your downloads domain
2. Open File Manager
3. Navigate to `public_html` or `www`
4. Upload all files from downloads-domain folder

### Step 3: Set Permissions

Set proper permissions for upload functionality:

```bash
# Make app folder writable
chmod 755 app/
chmod 644 app/axisinsurance.apk  # if APK already exists

# Make upload script executable
chmod 644 upload/upload.php
```

### Step 4: Update Main Domain URL in success.js

**IMPORTANT:** Edit `success.js` and update the `MAIN_DOMAIN` constant:

```javascript
// Line 4 in success.js
const MAIN_DOMAIN = 'https://yoursite.com'; // Change this!
```

Replace with your actual main domain URL.

### Step 5: Place APK File

Copy your APK file to the `app/` folder:

```bash
cp /path/to/axisinsurance.apk app/
```

Or upload it manually via FTP/cPanel.

### Step 6: Test the Setup

#### Test Success Page:
Visit: `https://downloads.yoursite.com/success.html?verified=true&mobile=1234567890&name=Test User`

You should see:
- ✅ Success page loads
- ✅ Customer name shows "Test User"
- ✅ Download buttons work
- ✅ APK downloads when clicked

#### Test Upload Page:
Visit: `https://downloads.yoursite.com/upload/upload.html`

You should see:
- ✅ Upload form loads
- ✅ Can select APK file
- ✅ Progress bar appears during upload
- ✅ Success message shows after upload
- ✅ File appears in `app/` folder

#### Test Without Verification:
Visit: `https://downloads.yoursite.com/success.html` (without parameters)

You should:
- ❌ Be redirected to main site
- ❌ Not see success page

## 🔒 Security Features

### 1. Verification Check
- `success.html` requires `verified=true` parameter
- Without it, users are redirected to main site
- Prevents unauthorized access

### 2. Timestamp Validation (Optional)
- Can add timestamp parameter for session expiry
- Expires after 5 minutes
- Edit `success.js` to enable

### 3. Mobile Number Tracking
- Tracks which customer accessed success page
- Stored in sessionStorage for download analytics

## 🔧 PHP Requirements

- **PHP Version:** 7.0 or higher
- **Extensions:** Standard (no special requirements)
- **Upload Limits:** Adjust in php.ini:
  ```ini
  upload_max_filesize = 50M
  post_max_size = 50M
  max_execution_time = 300
  ```

## 📊 Testing Checklist

After deployment, test:

- [ ] Success page loads from main domain redirect
- [ ] Customer name displays correctly
- [ ] APK download works from success page
- [ ] Direct access to success page redirects
- [ ] Upload page loads for admin
- [ ] File upload works and shows progress
- [ ] APK file appears in app/ folder
- [ ] Backup created before overwriting APK
- [ ] Mobile menu works on small screens
- [ ] Back to top button appears on scroll
- [ ] All images load correctly
- [ ] Footer links work

## 🌐 CORS Configuration (if needed)

If main domain and downloads domain are different origins, you may need CORS headers.

**Add to .htaccess** (if using Apache):
```apache
<IfModule mod_headers.c>
    Header set Access-Control-Allow-Origin "https://yoursite.com"
    Header set Access-Control-Allow-Methods "GET, POST, OPTIONS"
    Header set Access-Control-Allow-Headers "Content-Type"
</IfModule>
```

**Or add to PHP files:**
```php
header("Access-Control-Allow-Origin: https://yoursite.com");
```

## 🔄 Updating the APK

### Via Upload Page (Recommended):
1. Visit: `https://downloads.yoursite.com/upload/upload.html`
2. Select new APK file
3. Click Upload
4. Old file automatically backed up
5. New file replaces old one

### Via FTP/cPanel:
1. Backup current APK
2. Upload new APK to `app/` folder
3. Rename to `axisinsurance.apk`

## 📝 Troubleshooting

### Success page redirects even with verified=true
- Check browser console for errors
- Verify all URL parameters are present
- Check `MAIN_DOMAIN` setting in `success.js`

### APK won't download
- Check file exists in `app/` folder
- Verify file permissions (should be 644)
- Check browser console for errors

### Upload fails
- Check `app/` folder permissions (755)
- Verify PHP upload limits in php.ini
- Check server error logs
- Ensure folder is writable

### Images not loading
- Verify images exist in `img/` folder
- Check file permissions
- Verify paths in HTML files

## 📞 Support

If you encounter issues:
1. Check browser console (F12)
2. Check server error logs
3. Verify all file permissions
4. Test with simple PHP info page first

---

**Package Created:** October 2025  
**Version:** 1.0  
**Compatible With:** Main site verification system
